<?php
	include('scrap.php');
	include('simple_html_dom.php');

	if(!$_POST['url']){
		die;
	}

	$category = $_POST['url'];
	$url = 'https://www.coursera.org/'.$category;
	$elements = scrapCourses($url,true);
	$htmlResponse = '<table><tr><th>Category Name</th><th>Course Name</th><th>First Instructor Name</th><th>Course Description</th><th># of Students Enrolled</th><th># of Ratings</th></tr><tr>';

	$date = new DateTimeImmutable();
	$date = $date->getTimestamp();
	$fileName = './csvs/Coursera_' . $date . '.csv';
	$fh = fopen($fileName, "w");
	fputcsv($fh, array('Category Name', 'Course Name','First Instructor','Course Description','# of Students','# of ratings'), ";");

	foreach ($elements as $e) { 
		$links = $e->getElementsByTagname('a');
		$chkd = [];
		foreach($links as $a){
			$thisLink = urlNormalizer($a->getAttribute('href'));
			if(!in_array($thisLink, $chkd)){
				$chkd[]=$thisLink;
				$single = scrapSingle($thisLink);

				$courses['categoryName'] = '';
				$courses['categoryName'] = '';
				$courses['title'] = '';
				$courses['firstInstructor'] = '';
				$courses['courseDescription'] = '';
				$courses['totalStudents'] = '';
				$courses['courseRating'] = '';

				switch($single['courseType']){
					case 'mastertrack':
						$courses['categoryName'] = explode('>',$single['categoryName']->item(0)->nodeValue);
						$courses['categoryName'] = $courses['categoryName'][1];
						$courses['title'] = $single['courseName']->item(0)->nodeValue;
						$courses['firstInstructor'] = 'NA';
						$courses['courseDescription'] = $single['courseDescription']->item(0)->nodeValue;
						$courses['totalStudents'] = 'NA';
						$courses['courseRating'] = 'NA';
					break;
					case 'degrees':
						if(is_object($single['categoryName']->item(0))){ 
							$courses['categoryName'] = explode('>',$single['categoryName']->item(0)->nodeValue);
							$courses['categoryName'] = $courses['categoryName'][1];
						}
						if(is_object($single['courseName']->item(0))){$courses['title'] = $single['courseName']->item(0)->nodeValue;}
						$courses['firstInstructor'] = 'NA';
						if(is_object($single['courseDescription']->item(0))){$courses['courseDescription'] = $single['courseDescription']->item(0)->nodeValue;}
						$courses['totalStudents'] = 'NA';
						$courses['courseRating'] = 'NA';
					break;
					case 'professional-certificates':
						foreach($single['categoryName'] as $p){
							$cats = $p->getElementsByTagname('a');
							$category = $cats->item(2);
						}
						$courses['categoryName'] = $category->nodeValue;
						$courses['title'] = explode('|',$single['courseName']->item(0)->nodeValue);
						$courses['title'] = $courses['title'][0];
						if(is_object($single['firstInstructor']->item(0))){$courses['firstInstructor'] = $single['firstInstructor']->item(0)->nodeValue;}
						$description = '';
						foreach($single['courseDescription'] as $k){
							$description.=$k->nodeValue;
						}
						$courses['courseDescription'] = $description;
						if(is_object($single['courseRating']->item(0))){$studentsRatings = explode(' ratings', $single['courseRating']->item(0)->nodeValue);
						if($studentsRatings[1]){$courses['totalStudents'] = str_replace(' already enrolled','',$studentsRatings[1]);}
						$courses['courseRating'] = $studentsRatings[0];}
					break;
					case 'learn':
						$courses['categoryName'] = $single['categoryName']->item(2)->nodeValue;
						$courses['title'] = $single['courseName']->item(0)->nodeValue;
						$courses['firstInstructor'] = $single['firstInstructor']->item(0)->nodeValue;
						$courses['courseDescription'] = $single['courseDescription']->item(0)->nodeValue;
						if(is_object($single['totalStudents']->item(0))){$courses['totalStudents'] = str_replace(' already enrolled','',$single['totalStudents']->item(0)->nodeValue);}
						foreach($single['courseRating'] as $k){
							$ratings = $k->getElementsByTagname('span');
							$courses['courseRating'] = str_replace(' ratings','',$ratings->item($ratings->length-1)->nodeValue);
							break;
						}
					break;
					default:
						if(is_object($single['categoryName']->item(2))){$courses['categoryName'] = $single['categoryName']->item(2)->nodeValue;}
						if(is_object($single['courseName']->item(0))){$courses['title'] = $single['courseName']->item(0)->nodeValue;}
						if(is_object($single['firstInstructor']->item(0))){$courses['firstInstructor'] = $single['firstInstructor']->item(0)->nodeValue;}
						if(is_object($single['courseDescription']->item(0))){$courses['courseDescription'] = $single['courseDescription']->item(0)->nodeValue;}
						if(is_object($single['totalStudents']->item(0))){$courses['totalStudents'] = str_replace(' already enrolled','',$single['totalStudents']->item(0)->nodeValue);}
						foreach($single['courseRating'] as $k){
							$ratings = $k->getElementsByTagname('span');
							$courses['courseRating'] = str_replace(' ratings','',$ratings->item($ratings->length-1)->nodeValue);
							break;
						}
					break;
				}
				if ($courses['categoryName']!='') {
					fputcsv($fh, $courses);
				}
			}
		}
	}

	fclose($fh);

	echo json_encode(array("response"=>'Coursera_' . $date . '.csv'));
?>