<?php

function scrap($url,$full=null,$single=null){
	$ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); 
    $data = curl_exec($ch);
    curl_close($ch);

	$dom = new DOMDocument;
	@$dom->loadHTML($data);
	$xpath = new DOMXPath($dom);
	return $xpath;
}

function scrapCategories($url){
	$scrap = scrap($url);
	$elements = $scrap->query('//section[@class="rc-TopicAndSkills"]/div/div/div/div');
	return $elements;
}

function scrapCourses($url){
	$scrap = scrap($url);
	$elements = $scrap->query('//div[@class="rc-BrowseCarousel"]');
	return $elements;
}

function scrapSingle($url){
	$scrap = scrap($url);
	$courseType = getUrltype($url);
	$courseInformation = getClassCourse($courseType);
	// print_r($courseType);
	$response['courseType'] = $courseType;
	$response['categoryName'] = $scrap->query('//'.$courseInformation['categoryName']);
	$response['courseName'] = $scrap->query('//'.$courseInformation['classCourse']);
	$response['firstInstructor'] = $scrap->query('//'.$courseInformation['instructorName']);
	$response['courseDescription'] = $scrap->query('//'.$courseInformation['description']);
	$response['totalStudents'] = $scrap->query('//'.$courseInformation['totalStudents']);
	$response['courseRating'] = $scrap->query('//'.$courseInformation['ratings']);

	return $response;
}

function getUrltype($url){
	$url = explode('/', $url);
	return $url[3];
}

function getClassCourse($type){
	switch ($type) {
		case 'specializations':
			$response['categoryName'] = 'div[@class="_1ruggxy"]';
			$response['classCourse'] = 'div[contains(@class,"BannerTitle")]//h1';
			$response['instructorName'] = 'div[contains(@class,"instructor-wrapper")]//h3';
			$response['description'] = 'div[contains(@class,"description")]';
			$response['totalStudents'] = 'div[@class="_1fpiay2"]';
			$response['ratings'] = 'div[@class="sdpRatingLink"]';
		break;
		case 'learn':
			$response['categoryName'] = 'div[@class="_1ruggxy"]';
			$response['classCourse'] = 'div[contains(@class,"BannerTitle")]//h1';
			$response['instructorName'] = 'div[contains(@class,"instructor-wrapper")]//h3';
			$response['description'] = 'div[contains(@class,"description")]';
			$response['totalStudents'] = 'div[@class="_1fpiay2"]';
			$response['ratings'] = 'div[@class="rc-RatingLink"]';
		break;
		case 'degrees':
			$response['categoryName'] = 'ol[@class="breadcrumbs"]';
			$response['classCourse'] = 'div[contains(@class,"program-info-content")]//h1';
			$response['instructorName'] = 'na';
			$response['description'] = 'div[contains(@class,"programHighlights")]';
			$response['totalStudents'] = 'na';
			$response['ratings'] = 'na';
		break;
		case 'professional-certificates':
			$response['categoryName'] = 'ol[@class="css-1sswpa3"]';
			$response['classCourse'] = 'title';
			$response['instructorName'] = 'div[contains(@class,"css-6umcge")]//span';
			$response['description'] = 'div[contains (@class,"rc-TogglableContent")]//p[1]';
			$response['totalStudents'] = 'p[@class="css-14d8ngk"]';
			$response['ratings'] = 'div[contains (@class,"css-oj3vzs")]//span';
		break;
		case 'mastertrack':
			$response['categoryName'] = 'ol[@class="css-1sswpa3"]';
			$response['classCourse'] = 'div[contains(@class,"css-e00nzw")]//h1';
			$response['instructorName'] = 'p[@class="css-14ii0cd"]';
			$response['description'] = 'div[@class="content"]';
			$response['totalStudents'] = 'na';
			$response['ratings'] = 'na';
		break;
		
	}
	return $response;
}

function urlNormalizer($url){
	if (strpos($url, 'coursera.org')===false) {
		$url = 'https://www.coursera.org'.$url;
	}
	return $url;
}